

import java.util.Hashtable;
import java.util.Vector;

class ItemExemplar
{

    public ItemExemplar(int id, String name, int category)
    {
        this(id, name, category, 0, 0, 0, 0);
    }

    public ItemExemplar(int id, String name, int category, int arg1)
    {
        this(id, name, category, arg1, 0, 0, 0);
    }

    public ItemExemplar(int id, String name, int category, int arg1, int arg2)
    {
        this(id, name, category, arg1, arg2, 0, 0);
    }

    public ItemExemplar(int id, String name, int category, int arg1, int arg2, int arg3)
    {
        this(id, name, category, arg1, arg2, arg3, 0);
    }

    public ItemExemplar(int id, String name, int category, int arg1, int arg2, int arg3, int arg4)
    {
        this.id = id;
        this.name = name;
        this.category = category;
        switch(this.category)
        {
        case 1: // '\001'
            ammo1 = arg1;
            ammo2 = arg2;
            ammo3 = arg3;
            ammo4 = arg4;
            break;

        case 4: // '\004'
            ammoVariety = arg1;
            ammoCapacity = arg2;
            ammoNameList.addElement(this.name);
            break;

        case 3: // '\003'
            attachmentNameList.addElement(this.name);
            break;

        case 10: // '\n'
            attachmentNameList.addElement(this.name);
            break;

        case 5: // '\005'
            attachmentNameList.addElement(this.name);
            break;

        case 7: // '\007'
            attachmentNameList.addElement(this.name);
            break;
        }
        nameTable.put(name, new Integer(id));
        nameTable.put(new Integer(id), name);
        exemplarTable.put(name, this);
        exemplarTable.put(new Integer(id), this);
        nameList.addElement(this.name);
    }

    public static final int NONE_CATEGORY = 0;
    public static final int WEAPON_CATEGORY = 1;
    public static final int MELEE_WEAPON_CATEGORY = 2;
    public static final int WEAPON_ATTACHMENT_CATEGORY = 3;
    public static final int AMMO_CATEGORY = 4;
    public static final int GRENADE_CATEGORY = 5;
    public static final int EXPLOSIVE_CATEGORY = 6;
    public static final int DETONATOR_CATEGORY = 7;
    public static final int HELMET_CATEGORY = 8;
    public static final int BODY_ARMOR_CATEGORY = 9;
    public static final int ARMOR_ATTACHMENT_CATEGORY = 10;
    public static final int LEG_ARMOR_CATEGORY = 11;
    public static final int HEAD_GEAR_CATEGORY = 12;
    public static final int MEDICAL_CATEGORY = 13;
    public static final int TOOL_CATEGORY = 14;
    public static final int USABLE_ITEM_CATEGORY = 15;
    public static final int MISC_CATEGORY = 16;
    public static final int KEY_CATEGORY = 17;
    public static final int MONEY_CATEGORY = 18;
    public static Hashtable nameTable = new Hashtable();
    public static Hashtable exemplarTable = new Hashtable();
    public static Vector nameList = new Vector();
    public static Vector ammoNameList;
    public static Vector attachmentNameList;
    public int id;
    public String name;
    public int category;
    public int ammo1;
    public int ammo2;
    public int ammo3;
    public int ammo4;
    public int ammoVariety;
    public int ammoCapacity;

    static
    {
        ammoNameList = new Vector();
        attachmentNameList = new Vector();
        ammoNameList.addElement(ItemView.none);
        attachmentNameList.addElement(ItemView.none);
        new ItemExemplar(0, ItemView.none, 0);
        new ItemExemplar(1, "Glock 17", 1, 71, 73, 75);
        new ItemExemplar(2, "Glock 18", 1, 71, 73, 75);
        new ItemExemplar(3, "Beretta 92F", 1, 71, 73, 75);
        new ItemExemplar(4, "Beretta 92R", 1, 71, 73, 75);
        new ItemExemplar(5, ".38 Special", 1, 77, 78, 79);
        new ItemExemplar(6, "Barracuda", 1, 86, 88, 90);
        new ItemExemplar(7, "Desert Eagle", 1, 87, 89, 91);
        new ItemExemplar(8, "Colt .45", 1, 80, 82, 84);
        new ItemExemplar(9, "H&K MP5K", 1, 72, 74, 76);
        new ItemExemplar(10, "MAC-10", 1, 81, 83, 85);
        new ItemExemplar(11, "Thompson M1A1", 1, 81, 83, 85);
        new ItemExemplar(12, "Colt Commando", 1, 94, 95);
        new ItemExemplar(13, "H&K MP53", 1, 94, 95);
        new ItemExemplar(14, "AKSU-74", 1, 92, 93);
        new ItemExemplar(15, "FN-P90", 1, 105, 106);
        new ItemExemplar(16, "Type-85", 1, 96, 98);
        new ItemExemplar(17, "SKS", 1, 96, 98);
        new ItemExemplar(18, "Dragunov", 1, 96, 98);
        new ItemExemplar(19, "M24", 1, 100, 102);
        new ItemExemplar(20, "Steyr AUG", 1, 94, 95);
        new ItemExemplar(21, "H&K G41", 1, 94, 95);
        new ItemExemplar(22, "Ruger Mini-14", 1, 94, 95);
        new ItemExemplar(23, "C-7", 1, 94, 95);
        new ItemExemplar(24, "FA-MAS", 1, 94, 95);
        new ItemExemplar(25, "AK-74", 1, 92, 93);
        new ItemExemplar(26, "AKM", 1, 97, 99);
        new ItemExemplar(27, "M14", 1, 101, 103);
        new ItemExemplar(28, "FN-FAL", 1, 101, 103);
        new ItemExemplar(29, "H&K G3A3", 1, 101, 103);
        new ItemExemplar(30, "H&K G11", 1, 104);
        new ItemExemplar(31, "Remington M870", 1, 107, 108);
        new ItemExemplar(32, "SPAS-15", 1, 107, 108);
        new ItemExemplar(33, "CAWS", 1, 109, 110);
        new ItemExemplar(34, "FN Minimi", 1, 94, 95);
        new ItemExemplar(35, "RPK-74", 1, 92, 93);
        new ItemExemplar(36, "H&K 21", 1, 101, 103);
        new ItemExemplar(37, "Kampfmesser", 2);
        new ItemExemplar(38, "Wurfmesser", 2);
        new ItemExemplar(39, "Stein", 2);
        new ItemExemplar(40, "Granatwerfer", 1, 147, 148, 149, 150);
        new ItemExemplar(41, "Mrser", 1, 140);
        new ItemExemplar(42, "Noch ein Stein", 2);
        new ItemExemplar(43, "Klauen eines jungen mnnl. Monster", 2);
        new ItemExemplar(44, "Klauen eines jungen weibl. Monster", 2);
        new ItemExemplar(45, "Klauen eines erw. nnnl. Monster", 2);
        new ItemExemplar(46, "Klauen eines erw. weibl. Monster", 2);
        new ItemExemplar(47, "Knigin Tentakel", 2);
        new ItemExemplar(48, "Spucke Monsterknigin", 2);
        new ItemExemplar(49, "Schlagring", 2);
        new ItemExemplar(50, "Tragbarer Granatwerfer", 3);
        new ItemExemplar(51, "Panzerfaust", 1);
        new ItemExemplar(52, "Bloodcat Klauen", 2);
        new ItemExemplar(53, "Bloodcat Zhne", 2);
        new ItemExemplar(54, "Machete", 2);
        new ItemExemplar(55, "Raketengewehr", 1, 111, 112, 113);
        new ItemExemplar(56, "Automag III", 1, 100, 102);
        new ItemExemplar(57, "Infant Creature Spit", 2);
        new ItemExemplar(58, "Babymonsterspucke", 2);
        new ItemExemplar(59, "Monsterspucke", 2);
        new ItemExemplar(60, "Panzerkanone", 1);
        new ItemExemplar(61, "Pfeilpistole", 1, 114);
        new ItemExemplar(62, "Blutiges Wurfmesser", 2);
        new ItemExemplar(63, "Flammenwerfer", 1);
        new ItemExemplar(64, "Stemmeisen", 15);
        new ItemExemplar(65, "Auto Rocket Rifle", 1, 111, 112, 113);
        new ItemExemplar(71, "9mm Pistolenmagazin", 4, 0, 15);
        new ItemExemplar(72, "9mm SMG Magazin", 4, 0, 30);
        new ItemExemplar(73, "9mm Pistolenmagazin, AP", 4, 2, 15);
        new ItemExemplar(74, "9mm SMG Magazine, AP", 4, 2, 30);
        new ItemExemplar(75, "9mm Pistolenmagazin, HP", 4, 1, 15);
        new ItemExemplar(76, "9mm SMG Magazine, HP", 4, 1, 30);
        new ItemExemplar(77, ".38 Speed Loader", 4, 0, 6);
        new ItemExemplar(78, ".38 Speed Loader, AP", 4, 2, 6);
        new ItemExemplar(79, ".38 Speed Loader, HP", 4, 1, 6);
        new ItemExemplar(80, ".45 Pistolenmagazin", 4, 0, 7);
        new ItemExemplar(81, ".45 MP Magazine", 4, 0, 30);
        new ItemExemplar(82, ".45 Pistolenmagazin, AP", 4, 2, 7);
        new ItemExemplar(83, ".45 MP Magazine, AP", 4, 2, 30);
        new ItemExemplar(84, ".45 Pistolenmagazin, HP", 4, 1, 7);
        new ItemExemplar(85, ".45 MP Magazine, HP", 4, 1, 30);
        new ItemExemplar(86, ".357 Schnelllader", 4, 0, 6);
        new ItemExemplar(87, ".357 Magazin", 4, 0, 9);
        new ItemExemplar(88, ".357 Schnelllader, AP", 4, 2, 6);
        new ItemExemplar(89, ".357 Magazin, AP", 4, 2, 9);
        new ItemExemplar(90, ".357 Schnelllader, HP", 4, 1, 6);
        new ItemExemplar(91, ".357 Magazin, HP", 4, 1, 9);
        new ItemExemplar(92, "5.45mm Magazin", 4, 2, 30);
        new ItemExemplar(93, "5.45mm Magazin, HP", 4, 1, 30);
        new ItemExemplar(94, "5.56mm Magazin", 4, 2, 30);
        new ItemExemplar(95, "5.56mm Magazin, HP", 4, 1, 30);
        new ItemExemplar(96, "7.62mm WP Magazin, 10", 4, 2, 10);
        new ItemExemplar(97, "7.62mm WP Magazin, 30", 4, 2, 30);
        new ItemExemplar(98, "7.62mm WP Magazin, 10 HP", 4, 1, 10);
        new ItemExemplar(99, "7.62mm WP Magazin, 30 HP", 4, 1, 30);
        new ItemExemplar(100, "7.62mm NATO Magazin, 5", 4, 2, 5);
        new ItemExemplar(101, "7.62mm NATO Magazin, 20", 4, 2, 20);
        new ItemExemplar(102, "7.62mm NATO Magazin, 5 HP", 4, 1, 5);
        new ItemExemplar(103, "7.62mm NATO Magazine, 20 HP", 4, 1, 20);
        new ItemExemplar(104, "4.7mm Magazin", 4, 2, 50);
        new ItemExemplar(105, "5.7mm Magazin", 4, 2, 50);
        new ItemExemplar(106, "5.7mm Magazin, HP", 4, 1, 50);
        new ItemExemplar(107, "12 Kaliber Magazin", 4, 3, 7);
        new ItemExemplar(108, "12 Kaliber Magazin, grober Schrott", 4, 4, 7);
        new ItemExemplar(109, "CAWS Magazin", 4, 3, 10);
        new ItemExemplar(110, "CAWS Magazine, grober Schrott", 4, 4, 10);
        new ItemExemplar(111, "Miniraketen, AP", 4, 9, 5);
        new ItemExemplar(112, "Miniraketen, HP", 4, 8, 5);
        new ItemExemplar(113, "Miniraketen, HEAP", 4, 10, 5);
        new ItemExemplar(114, "Betubungspfeil", 4, 11, 1);
        new ItemExemplar(131, "Vakuumgranate", 5);
        new ItemExemplar(132, "Betubungsgranate", 5);
        new ItemExemplar(133, "Senfgasgranate", 5);
        new ItemExemplar(134, "Mini Handgranate", 5);
        new ItemExemplar(135, "Handgranate", 5);
        new ItemExemplar(136, "Ein Gef mit Cyklonitkristallen", 6);
        new ItemExemplar(137, "TNT", 6);
        new ItemExemplar(138, "HMX", 6);
        new ItemExemplar(139, "C1", 6);
        new ItemExemplar(140, "Mrsergescho", 5);
        new ItemExemplar(141, "Mine", 6);
        new ItemExemplar(142, "C4", 6);
        new ItemExemplar(143, "Leuchtmine", 6);
        new ItemExemplar(144, "Leucht-Alarmmine", 6);
        new ItemExemplar(145, "Plastik-Sprengladung", 6);
        new ItemExemplar(146, "Leuchtstab", 5);
        new ItemExemplar(147, "40mm Granate", 5);
        new ItemExemplar(148, "40mm Betubungsgranate", 5);
        new ItemExemplar(149, "40mm Vakuumgranate", 5);
        new ItemExemplar(150, "40mm Rauchgranate", 5);
        new ItemExemplar(151, "Rauchgranate", 5);
        new ItemExemplar(152, "Panzergranate", 5);
        new ItemExemplar(153, "Gebudefeuer", 6);
        new ItemExemplar(154, "Monstercocktail", 5);
        new ItemExemplar(155, "Gebudeexplosion", 6);
        new ItemExemplar(156, "Groe Explosion", 6);
        new ItemExemplar(157, "Trnengas, gro", 5);
        new ItemExemplar(158, "Monstergas, klein ", 6);
        new ItemExemplar(159, "Monstergas, gro", 6);
        new ItemExemplar(161, "Splitterschutzweste", 9);
        new ItemExemplar(162, "Compound 18 Splitterschutzweste", 9);
        new ItemExemplar(163, "Beschichtete Splitterschutzweste", 9);
        new ItemExemplar(164, "Kevlarweste", 9);
        new ItemExemplar(165, "Compound 18 Kevlarweste", 9);
        new ItemExemplar(166, "Beschichtete Kevlarweste", 9);
        new ItemExemplar(167, "Spectraweste", 9);
        new ItemExemplar(168, "Comp 18 Spectraweste", 9);
        new ItemExemplar(169, "Beschichtete Spectraweste", 9);
        new ItemExemplar(170, "Kevlarhosen", 11);
        new ItemExemplar(171, "Comp 18 Kevlarhosen", 11);
        new ItemExemplar(172, "Beschichtete Kevlarhosen", 11);
        new ItemExemplar(173, "Spectrahosen", 11);
        new ItemExemplar(174, "Comp 18 Spectrahosen", 11);
        new ItemExemplar(175, "Beschichtete Spectrahosen", 11);
        new ItemExemplar(176, "Stahlhelm", 8);
        new ItemExemplar(177, "Kevlarhelm", 8);
        new ItemExemplar(178, "Comp 18 Kevlarhelm", 8);
        new ItemExemplar(179, "Beschichteter Kevlarhelm", 8);
        new ItemExemplar(180, "Spectra Helmet", 8);
        new ItemExemplar(181, "Comp 18 Spectrahelm", 8);
        new ItemExemplar(182, "Beschichteter Spectrahelm", 8);
        new ItemExemplar(183, "Keramikplatten", 10);
        new ItemExemplar(184, "Monsterbabyhaut", 9);
        new ItemExemplar(185, "Monsterjungtierhaut", 9);
        new ItemExemplar(186, "Monsterhaut", 9);
        new ItemExemplar(187, "Monsterkniginhaut", 9);
        new ItemExemplar(188, "Lederjacke", 9);
        new ItemExemplar(189, "Leder & Kevlarjacke", 9);
        new ItemExemplar(190, "Comp 18 Leder & Kevlarjacke", 9);
        new ItemExemplar(191, "Beschichtete Leder & Kevlarjacke", 9);
        new ItemExemplar(192, "Haut eines jungen weiblichen Monsters", 9);
        new ItemExemplar(193, "Haut eines alten weiblichen Monsters", 9);
        new ItemExemplar(194, "Arulco T-Shirt", 9);
        new ItemExemplar(195, "Deidranna T-Shirt", 9);
        new ItemExemplar(196, "Guardian-Weste", 9);
        new ItemExemplar(197, "Guardianweste mit Compound 18", 9);
        new ItemExemplar(198, "Beschichtete Guardian-Weste", 9);
        new ItemExemplar(201, "Erste-Hilfe-Kasten", 13);
        new ItemExemplar(202, "Arztkoffer", 13);
        new ItemExemplar(203, "Werkzeugkoffer", 14);
        new ItemExemplar(204, "Schlosserwerkzeug", 14);
        new ItemExemplar(205, "Tarnset", 15);
        new ItemExemplar(206, "Sprengfallen-Set", 15);
        new ItemExemplar(207, "Schalldmpfer", 3);
        new ItemExemplar(208, "Zielfernrohr", 3);
        new ItemExemplar(209, "Stnder", 3);
        new ItemExemplar(210, "Richtmikro", 12);
        new ItemExemplar(211, "Nachtsichtgert", 12);
        new ItemExemplar(212, "Sonnenbrille", 12);
        new ItemExemplar(213, "Gas Maske", 12);
        new ItemExemplar(214, "Feldflasche", 15);
        new ItemExemplar(215, "Metalldetektor", 15);
        new ItemExemplar(216, "Compound 18", 15);
        new ItemExemplar(217, "Glibber Royale", 15);
        new ItemExemplar(218, "Glas mit Elixier", 14);
        new ItemExemplar(219, "Geld", 18);
        new ItemExemplar(220, "Einmachglas", 16);
        new ItemExemplar(221, "Glas mit Blut", 16);
        new ItemExemplar(222, "Energie Booster", 13);
        new ItemExemplar(223, "Znder", 7);
        new ItemExemplar(224, "Fernznder", 7);
        new ItemExemplar(225, "Videoband", 16);
        new ItemExemplar(226, "Urkunde Angel Shop", 16);
        new ItemExemplar(227, "Brief von Enrico", 16);
        new ItemExemplar(228, "Diskette", 16);
        new ItemExemplar(229, "Kelch des Glcks", 16);
        new ItemExemplar(230, "Bloodcat Klauen", 16);
        new ItemExemplar(231, "Bloodcat Zhne", 16);
        new ItemExemplar(232, "Bloodcat Fell", 16);
        new ItemExemplar(233, "Schalter", 16);
        new ItemExemplar(234, "Action-Gegenstand", 16);
        new ItemExemplar(235, "Regenerations Booster", 13);
        new ItemExemplar(236, "Spritze", 13);
        new ItemExemplar(237, "Spritze", 13);
        new ItemExemplar(238, "Spritze", 13);
        new ItemExemplar(239, "Glas mit menschlichem Blut", 16);
        new ItemExemplar(240, "Ownership", 16);
        new ItemExemplar(241, "Laserpointer", 3);
        new ItemExemplar(242, "Fernznder", 7);
        new ItemExemplar(243, "Drahtschere", 14);
        new ItemExemplar(244, "Duckbill", 3);
        new ItemExemplar(245, "Flasche mit Alkohol", 15);
        new ItemExemplar(246, "UV Nachtsichtgert", 12);
        new ItemExemplar(247, "Gebrauchter Raketenwerfer", 1);
        new ItemExemplar(248, "Kopf", 16);
        new ItemExemplar(249, "Imposter's Kopf", 16);
        new ItemExemplar(250, "T-Rex's Kopf", 16);
        new ItemExemplar(251, "Slay's Kopf", 16);
        new ItemExemplar(252, "Druggist's Kopf", 16);
        new ItemExemplar(253, "Matron's Kopf", 16);
        new ItemExemplar(254, "Tiffany's Kopf", 16);
        new ItemExemplar(255, "Wein", 15);
        new ItemExemplar(256, "Bier", 15);
        new ItemExemplar(257, "Porno Magazin", 16);
        new ItemExemplar(258, "Videokamera", 16);
        new ItemExemplar(259, "Roboter-Fernbedienung", 12);
        new ItemExemplar(260, "Monsterklaue", 16);
        new ItemExemplar(261, "Monsterfleisch", 16);
        new ItemExemplar(262, "Monsterorgan", 16);
        new ItemExemplar(263, "Fernbedienung", 16);
        new ItemExemplar(264, "Platinuhr", 16);
        new ItemExemplar(265, "Golfschlger", 16);
        new ItemExemplar(266, "Walkman", 16);
        new ItemExemplar(267, "Tragbarer Fernseher", 16);
        new ItemExemplar(268, "Aktueller Kontostand:", 16);
        new ItemExemplar(269, "Zigarrren", 16);
        new ItemExemplar(271, "Kleiner Schlssel", 17);
        new ItemExemplar(272, "Gefngnisschlssel", 17);
        new ItemExemplar(273, "billiger Schlssel", 17);
        new ItemExemplar(274, "Glanzloser Schlssel", 17);
        new ItemExemplar(275, "Glnzender Schlssel", 17);
        new ItemExemplar(276, "Schlssel fr Vorhngeschlo", 17);
        new ItemExemplar(277, "Electronischer Schlssel", 17);
        new ItemExemplar(278, "Codekarte", 17);
        new ItemExemplar(279, "Schlssel", 17);
        new ItemExemplar(280, "Schlssel", 17);
        new ItemExemplar(281, "Schlssel", 17);
        new ItemExemplar(282, "Schlssel", 17);
        new ItemExemplar(283, "Schlssel", 17);
        new ItemExemplar(284, "Schlssel", 17);
        new ItemExemplar(285, "Schlssel", 17);
        new ItemExemplar(286, "Schlssel", 17);
        new ItemExemplar(287, "Schlssel", 17);
        new ItemExemplar(288, "Schlssel", 17);
        new ItemExemplar(289, "Schlssel", 17);
        new ItemExemplar(290, "Schlssel", 17);
        new ItemExemplar(291, "Schlssel", 17);
        new ItemExemplar(292, "Schlssel", 17);
        new ItemExemplar(293, "Schlssel", 17);
        new ItemExemplar(294, "Schlssel", 17);
        new ItemExemplar(295, "Schlssel", 17);
        new ItemExemplar(296, "Schlssel", 17);
        new ItemExemplar(297, "Schlssel", 17);
        new ItemExemplar(298, "Schlssel", 17);
        new ItemExemplar(299, "Schlssel", 17);
        new ItemExemplar(300, "Schlssel", 17);
        new ItemExemplar(301, "Schlssel", 17);
        new ItemExemplar(302, "Schlssel", 17);
        new ItemExemplar(303, "Silbertablett", 16);
        new ItemExemplar(304, "Klebeband", 16);
        new ItemExemplar(305, "Aluminiumstange", 16);
        new ItemExemplar(306, "Feder", 16);
        new ItemExemplar(307, "Bolzen & Feder", 3);
        new ItemExemplar(308, "Stahlrohr", 16);
        new ItemExemplar(309, "Sekundenkleber", 16);
        new ItemExemplar(310, "Gewehrlauf-Verlngerung", 3);
        new ItemExemplar(311, "Schnur", 16);
        new ItemExemplar(312, "Blechdose", 16);
        new ItemExemplar(313, "Blechdose mit Schnur", 15);
        new ItemExemplar(314, "Murmeln", 15);
        new ItemExemplar(315, "LameBoy Display", 16);
        new ItemExemplar(316, "Kupferdraht", 16);
        new ItemExemplar(317, "Display", 16);
        new ItemExemplar(318, "FumblePak", 16);
        new ItemExemplar(319, "Rntgenrhre", 16);
        new ItemExemplar(320, "Kaugummi", 16);
        new ItemExemplar(321, "Rntgengert", 16);
        new ItemExemplar(322, "Batterien", 15);
        new ItemExemplar(323, "Gummiband", 16);
        new ItemExemplar(324, "Rntgenstrahlendetektor", 15);
        new ItemExemplar(325, "Silber Nugget", 18);
        new ItemExemplar(326, "Gold Nugget", 18);
        new ItemExemplar(327, "Benzintank", 15);
    }
}
